Attribute VB_Name = "MdlDataChgFunc"
Option Explicit

Const Swr_G_Index As Integer = 0                ' G
Const Swr_Mega_Index As Integer = 1             ' M
Const Swr_K_Index As Integer = 2                ' K
Const Swr___Index As Integer = 3                '
Const Swr_m_Index As Integer = 4                ' m
Const Swr_u_Index As Integer = 5                ' 
Const Swr_n_Index As Integer = 6                ' n
Const Swr_p_Index As Integer = 7                ' p


Public Function stepval(code As Integer, round As Integer, lval$, stp1$, stp2$) As String
    Dim stp As Double
    Dim ofs As Double
    Dim nval As Double   ' Always, double precision
    stepval = lval
    Select Case code
        Case vbKeyPageUp:   stp = stp2
        Case vbKeyPageDown: stp = -stp2
        Case vbKeyUp:       stp = stp1
        Case vbKeyDown:     stp = -stp1
        Case Else:          Exit Function
    End Select
    If round = True Then
        If (stp * lval) < 0 Then ofs = 0.9 Else ofs = 0.00001
        nval = Sgn(lval) * Fix(Abs(lval / stp) + ofs) * Abs(stp)
    Else
        nval = lval
    End If
    stepval = nval + stp
End Function

Public Sub StepVal_Int(code As Integer, round As Integer, lval As Integer, stp1 As Integer, stp2 As Integer, mn As Integer, mx As Integer)
    lval = stepval(code, round, CStr(lval), CStr(stp1), CStr(stp2))
    If lval < mn Then
        lval = mn
    ElseIf lval > mx Then
        lval = mx
    End If
End Sub

Public Sub StepVal_Sng(code As Integer, round As Integer, lval As Single, stp1 As Single, stp2 As Single, mn As Single, mx As Single)
    lval = stepval(code, round, CStr(lval), CStr(stp1), CStr(stp2))
    If lval < mn Then
        lval = mn
    ElseIf lval > mx Then
        lval = mx
    End If
End Sub

Public Sub StepVal_Dbl(code As Integer, round As Integer, lval As Double, stp1 As Double, stp2 As Double, mn As Double, mx As Double)
    lval = stepval(code, round, CStr(lval), CStr(stp1), CStr(stp2))
    If lval < mn Then
        lval = mn
    ElseIf lval > mx Then
        lval = mx
    End If
End Sub

'*************************************************************
' Pʂ̕ɉ\tH[}bgƕϊlԂ܂B
'*************************************************************
Public Function get_StimUnit(strUnit As String, strFrmt As String) As Double
    
    If strUnit = "GHz" Then
        get_StimUnit = Unit_g: strFrmt = fGHz$
    ElseIf strUnit = "MHz" Then
        get_StimUnit = Unit_mega: strFrmt = fMHz$
    ElseIf strUnit = "kHz" Then
        get_StimUnit = Unit_k: strFrmt = fkHz$
    ElseIf strUnit = "Hz" Then
        get_StimUnit = 1#: strFrmt = fHz$
    End If
    
End Function

'****************************************************************************
' gw肩瑪g|Cg̎gȂ|CglԂ
'****************************************************************************
Public Function search_freq_point(lngMsrP As Long, dblFreq As Double, dblMeasFreq As Double) As Integer
    Dim i As Integer
    Dim tmp1 As Double
    Dim tmp2 As Double
    
    If dblFreq < BufFrq(0, lngACh) Then
        dblMeasFreq = BufFrq(0, lngACh)
        search_freq_point = 0
        Exit Function
    ElseIf BufFrq(lngMsrP - 1, lngACh) < dblFreq Then
        dblMeasFreq = BufFrq(lngMsrP - 1, lngACh)
        search_freq_point = lngMsrP - 1
        Exit Function
    End If
    
    For i = 0 To lngMsrP - 2
        If BufFrq(i, lngACh) <= dblFreq And dblFreq <= BufFrq(i + 1, lngACh) Then
            tmp1 = dblFreq - BufFrq(i, lngACh)
            tmp2 = BufFrq(i + 1, lngACh) - dblFreq
            If tmp1 < tmp2 Then
                dblMeasFreq = BufFrq(i, lngACh)
                search_freq_point = i
            Else
                dblMeasFreq = BufFrq(i + 1, lngACh)
                search_freq_point = i + 1
            End If
            Exit For
        End If
    Next i

End Function

'******************************************
' NA̎gEo̓xݒ̃Abv[h
'******************************************
Public Sub get_stim(frm As frmCH, ActCh As Long, intFileRecall As Integer)
    Dim sta As Double, sto As Double, cen As Double, Point As Long
    Dim segn As Integer
    Dim rbw As Single
    Dim unit As String
    Dim i As Long
    Dim strFmt As String
    Dim lngErr As Long
    Dim denominator As Double
    
    If intFileRecall <> cnt_FILE_RECALL And RdCsvInfo.RdFileSetup = False Then
        lngErr = QrySourSeg(lngPID, CH_Stimu(0, ActCh))
        lngErr = QrySourSegCoun(lngPID, ChInfo(ActCh).StimuNum)
        lngErr = QrySensCorrPortExtTime(lngPID, BIS_PORT1, ChInfo(ActCh).Correct.PortExtCorrTime)
        lngErr = QryCalcTranImpCimp(lngPID, ChInfo(ActCh).ImpZ0)
    End If
    
    With ChInfo(ActCh)
        segn = CInt(frm.Text_stm(0).Text)
        If segn > ChInfo(ActCh).StimuNum Then segn = ChInfo(ActCh).StimuNum
        frm.Text_stm(0).Text = segn
        If segn < ChInfo(ActCh).StimuNum Then
            sta = CH_Stimu(segn, ActCh).dblFreq1
            sto = CH_Stimu(segn, ActCh).dblFreq2
            If CH_Stimu(segn, ActCh).lngFtype Then sta = sta - (sto / 2): sto = sta + sto ' Converts cen/spa to sta/sto.
            
            CH_Stimu(segn, ActCh).dblFreq1 = sta
            CH_Stimu(segn, ActCh).dblFreq2 = sto
    
            denominator = get_StimUnit(frm.Combo_StimUnit(StimFRQ).Text, strFmt)
            frm.Text_stm(1).Text = Format(Format(sta / denominator, strFmt))
            
            denominator = get_StimUnit(frm.Combo_StimUnit(StimFRQ).Text, strFmt)
            frm.Text_stm(2).Text = Format(Format(sto / denominator, strFmt))
            
            denominator = get_StimUnit(frm.Combo_StimUnit(StimFRQ).Text, strFmt)
            frm.Text_stm(3).Text = Format(Format((sta + sto) / (denominator * 2), strFmt))
            
            If frm.Combo_StimUnit(StimFRQ).Text = "GHz" Then
                frm.Text_stm(4).Text = Format(Format((sto - sta) / Unit_g, fGHz$))
            ElseIf frm.Combo_StimUnit(StimFRQ).Text = "MHz" Then
                frm.Text_stm(4).Text = Format(Format((sto - sta) / Unit_mega, fMHz$))
            ElseIf frm.Combo_StimUnit(StimFRQ).Text = "kHz" Then
                frm.Text_stm(4).Text = Format(Format((sto - sta) / Unit_k, fkHz$))
            Else
                frm.Text_stm(4).Text = Format(Format((sto - sta) / Unit_k, fkHz$))
            End If
            
            frm.Text_stm(5).Text = CH_Stimu(segn, ActCh).lngPntN
            frm.Text_stm(6).Text = Format(CH_Stimu(segn, ActCh).sngPow1, "#0.0")
            frm.Text_stm(7).Text = Format(CH_Stimu(segn, ActCh).sngPow2, "#0.0")
            frm.Text_stm(8).Text = Format(CH_Stimu(segn, ActCh).sngStime * 1000, "#0.00")
            ' IF RBW
            CH_IfRbw(ActCh) = CH_Stimu(segn, ActCh).sngRbw
            rbw = CH_IfRbw(ActCh): unit = "Hz"
            If rbw >= 1000 Then rbw = rbw / 1000: unit = "kHz"
            frm.Combo_rbw.Text = Format(CStr(rbw) & unit, rbwStr)
        Else
            frm.Text_stm(1).Text = " "
            frm.Text_stm(2).Text = " "
            frm.Text_stm(3).Text = " "
            frm.Text_stm(4).Text = " "
            frm.Text_stm(5).Text = " "
            frm.Text_stm(6).Text = " "
            frm.Text_stm(7).Text = " "
            frm.Text_stm(8).Text = " "
            frm.Combo_rbw.ListIndex = -1
        End If
    
        Point = 0
        For i = 0 To ChInfo(ActCh).StimuNum - 1
            Point = Point + CH_Stimu(i, ActCh).lngPntN
        Next i
        .lngTotP = Point
        frm.Text_z0.Text = Format(ChInfo(ActCh).ImpZ0, "#0")
        frm.Text_PortExt.Text = Format(ChInfo(ActCh).Correct.PortExtCorrTime * Multiple_p, "##0.000")
    End With
    
    lngErr = QrySourFreqTab(lngPID, lngACh + 1, BufFrq(0, lngACh))     '|Cg̎gl̓ǂݏo
    
End Sub

'********************
' ZԂ̓ǂݏo
'********************
Public Sub cor_disp(ByRef frm As frmCH, ByVal ch As Long)
    Dim lngErr As Long
        
    lngErr = QrySensCorrCsetStat(lngPID, ChInfo(ch).Correct.CorOn)
    With frmMain
        If ChInfo(ch).Correct.CorOn <> 0 Then
            frm.Check_cal.Value = 1
            If ChInfo(ch).Correct.CorOn = 1 Then
                frm.Text_hd.Text = "Cor"    'Z ON
                .Frame_count.Enabled = True
            ElseIf ChInfo(ch).Correct.CorOn = 2 Then
                frm.Text_hd.Text = "C?"     'Z ON()
                .Frame_count.Enabled = True
            Else
                frm.Text_hd.Text = "C!"     'Z ON(ԊO)
                .Frame_count.Enabled = False
            End If
        Else
            frm.Check_cal.Value = 0         'Z OFF
            frm.Text_hd.Text = ""
            .Frame_count.Enabled = False
        End If
    End With
End Sub

'****************************************
' p[|̑|Cg̃xZo
'****************************************
Private Sub get_LevelSwpInfo(ActCh As Long, stimNum As Long)
    Dim bln As Boolean
    Dim i As Integer
    Dim Pnt As Long
    Dim f1 As Double
    Dim f2 As Double
    Dim lvl As Single
    Dim lev1 As Single
    Dim lev2 As Single
    Dim tmp As Single
    
    Pnt = ChInfo(ActCh).lngTotP
    
    bln = False
    For i = 0 To stimNum - 1
        f1 = CH_Stimu(i, ActCh).dblFreq1
        f2 = CH_Stimu(i, ActCh).dblFreq2
        lev1 = CH_Stimu(i, ActCh).sngPow1
        lev2 = CH_Stimu(i, ActCh).sngPow2
        If f1 <> f2 Then bln = True: Exit For
    Next i

    If bln = True Then
        For i = 0 To Pnt - 1
            BufLvl(i, ActCh) = ERR_VALUE
        Next i
    Else
        If lev1 > lev2 Then
            lvl = (lev1 - lev2) / CSng(Pnt - 1) * -1
        Else
            lvl = (lev2 - lev1) / CSng(Pnt - 1)
        End If
        For i = 0 To Pnt - 1
            tmp = CLng((lev1 + lvl * i) * 1000)
            BufLvl(i, ActCh) = CSng(tmp) / 1000#       '̃|CgPower Level߂܂B
        Next i
    End If

End Sub

'********************************************
' NA̎gEo̓xݒ̃ZbgEAbv
'********************************************
Public Sub set_stim(frm As frmCH, ActCh As Long, typ As Long)
    Dim f1 As Double, f2 As Double
    Dim cen As Double, spa As Double
    Dim rbw As Single, lev1 As Single, lev2 As Single
    Dim dum As SourSeg
    Dim segn As Integer
    Dim Pnt As Long
    Dim unitVal As Double
    Dim strFmt As String
    Dim lngErr As Long
    Dim DispNo As Long
    Dim GrphRect As struct_Rectangular_coordinate
    Dim GrphPolar As struct_PolarCoordinates
    
    With ChInfo(ActCh)
        lngErr = BisCalcTranImpCimp(lngPID, .ImpZ0)
        If .Correct.PortExtCorrTime <> 0 Then
            lngErr = BisSensCorrPortExtTime(lngPID, BIS_PORT1, .Correct.PortExtCorrTime)
            lngErr = BisSensCorrPortExtStat(lngPID, BIS_ON)
        Else
            lngErr = BisSensCorrPortExtStat(lngPID, BIS_OFF)
        End If

        segn = CInt(frm.Text_stm(0).Text)
        If frm.Text_stm(5).Text = "0" And segn > 0 And segn = (ChInfo(ActCh).StimuNum - 1) Then
            segn = segn - 1: frm.Text_stm(0).Text = segn
            ChInfo(ActCh).StimuNum = ChInfo(ActCh).StimuNum - 1
        Else
            If frm.Text_stm(1).Text = " " Or frm.Text_stm(2).Text = " " Then typ = 1
            If frm.Text_stm(1).Text = " " Then frm.Text_stm(1).Text = "1"
            If frm.Text_stm(2).Text = " " Then frm.Text_stm(2).Text = "1"
            If frm.Text_stm(3).Text = " " Then frm.Text_stm(3).Text = "1"
            If frm.Text_stm(4).Text = " " Then frm.Text_stm(4).Text = "0"
            If frm.Text_stm(5).Text = " " Then frm.Text_stm(5).Text = "1"
            If frm.Text_stm(6).Text = " " Then frm.Text_stm(6).Text = "0"
            If frm.Text_stm(7).Text = " " Then frm.Text_stm(7).Text = "0"
            If frm.Text_stm(8).Text = " " Then frm.Text_stm(8).Text = "0"
            If frm.Combo_rbw.ListIndex = -1 Then CH_IfRbw(ActCh) = 10000
            If frm.Text_stm(5).Text = "0" Then frm.Text_stm(5).Text = 1
            If CLng(frm.Text_stm(5).Text) < 2 And segn = 0 And ChInfo(ActCh).StimuNum = 1 Then frm.Text_stm(5).Text = 2
            If typ Then
                unitVal = get_StimUnit(frm.Combo_StimUnit(StimFRQ).Text, strFmt)
                f1 = CDbl(frm.Text_stm(3).Text) * unitVal
                unitVal = get_StimUnit(frm.Combo_StimUnit(StimFRQ).Text, strFmt)
                f2 = CDbl(frm.Text_stm(4).Text) * unitVal
            Else
                unitVal = get_StimUnit(frm.Combo_StimUnit(StimFRQ).Text, strFmt)
                f1 = CDbl(frm.Text_stm(1).Text) * unitVal
                unitVal = get_StimUnit(frm.Combo_StimUnit(StimFRQ).Text, strFmt)
                f2 = CDbl(frm.Text_stm(2).Text) * unitVal
            End If
            Pnt = CLng(frm.Text_stm(5).Text)
            lev1 = CSng(frm.Text_stm(6).Text)
            lev2 = CSng(frm.Text_stm(7).Text)
            CH_Stimu(segn, ActCh).dblFreq1 = f1
            CH_Stimu(segn, ActCh).dblFreq2 = f2
            CH_Stimu(segn, ActCh).lngPntN = Pnt
            CH_Stimu(segn, ActCh).lngFmode = BIS_FREQ_LIN
            CH_Stimu(segn, ActCh).lngFtype = typ
            CH_Stimu(segn, ActCh).sngPow1 = lev1
            CH_Stimu(segn, ActCh).sngPow2 = lev2
            CH_Stimu(segn, ActCh).sngRbw = CH_IfRbw(ActCh)
            CH_Stimu(segn, ActCh).sngStime = CSng(frm.Text_stm(8).Text) / 1000
        End If
        If ChInfo(ActCh).StimuNum < (segn + 1) Then ChInfo(ActCh).StimuNum = segn + 1
        Err = BisSourSeg(lngPID, CH_Stimu(0, ActCh), LenB(dum) * ChInfo(ActCh).StimuNum)
        Call get_LevelSwpInfo(ActCh, ChInfo(ActCh).StimuNum)
    End With
    
    Call get_stim(frm, ActCh, cnt_FILE_NOT_RE)
    '茋ʁiLOGUjCH1̃f[^ǂݏo܂
    lngErr = QryTracData(lngPID, ChInfo(ActCh).TrLgm, 0, ChInfo(ActCh).lngTotP - 1, BufLgm(0, ActCh))
    If intFrmCh(ActCh) Then
        Call GridDisp(frm.PictBox_Waveform, ChInfo(ActCh).WaveFrmt, ChInfo(ActCh).lngTotP - 1, GrphRect, GrphPolar)
    End If
    Call cor_disp(frm, ActCh)

End Sub

'***************************************************
' CH̍ZԂ̎擾iSčZς݂́ATrueԂ)
'***************************************************
Public Function get_ChFlgCorChk(mx_ch As Long) As Boolean
    Dim ch As Long
    
    get_ChFlgCorChk = True
    For ch = 0 To mx_ch - 1
        With ChInfo(ch).Correct
            If .CorOn <> 1 And .CorOn <> 2 Then
                get_ChFlgCorChk = False
                Exit For
            End If
        End With
    Next ch
End Function


'*********************************************************************
' CH̍ZԂBNAǂݎmFiSčZς݂́ATrueԂ)
'*********************************************************************
Public Function get_ChCorChk(mx_ch As Long) As Boolean
    Dim lngErr As Long
    Dim ch As Long
    
    get_ChCorChk = True
    For ch = 0 To mx_ch - 1
        Call cor_disp(frm_CH(ch), ch)
        If ChInfo(ch).Correct.CorOn <> 1 And ChInfo(ch).Correct.CorOn <> 2 Then
            get_ChCorChk = False
        End If
    Next ch
End Function


Public Function get_scale_unit(ByRef Index As Integer) As Single
    Dim d As Single
    
    d = Unit_s
    
    If Index = Swr_G_Index Then
        d = Unit_g
    ElseIf Index = Swr_Mega_Index Then
        d = Unit_mega
    ElseIf Index = Swr_K_Index Then
        d = Unit_k
    ElseIf Index = Swr___Index Then
        d = Unit_s
    ElseIf Index = Swr_m_Index Then
        d = Unit_m
    ElseIf Index = Swr_u_Index Then
        d = Unit_u
    ElseIf Index = Swr_n_Index Then
        d = Unit_n
    ElseIf Index = Swr_p_Index Then
        d = Unit_p
    End If

    get_scale_unit = d
End Function

'***********************
' dt ̒Pʔ͈̓`FbN
'***********************
Public Function get_unit_index(ByVal dt As Double) As Integer
    Dim i As Integer

    i = Swr___Index

    If dt >= Unit_g Then
        i = Swr_G_Index
    ElseIf dt >= Unit_mega Then
        i = Swr_Mega_Index
    ElseIf dt >= Unit_k Then
        i = Swr_K_Index
    ElseIf dt >= Unit_s Then
        i = Swr___Index
    ElseIf dt >= Unit_m Then
        i = Swr_m_Index
    ElseIf dt >= Unit_u Then
        i = Swr_u_Index
    ElseIf dt >= Unit_n Then
        i = Swr_n_Index
    ElseIf dt >= Unit_p Then
        i = Swr_p_Index
    End If

    get_unit_index = i

End Function


'********************************
' PʕύXɂ\f[^̍쐬
'********************************
Public Function chg_scale_unit(ByVal CmbIndex As Integer, ByVal dt As Single) As String
    Dim s As String
    Dim d As Single
    Dim HalfAdjust As Single

    d = dt
    s = ""
    If CmbIndex = Swr_G_Index Then
        HalfAdjust = 0.005 * Unit_g
        d = (dt + HalfAdjust) * Multiple_g
        s = Format(d, "##0")
    ElseIf CmbIndex = Swr_Mega_Index Then
        HalfAdjust = 0.005 * Unit_mega
        d = (dt + HalfAdjust) * Multiple_mega
        s = Format(d, "##0")
    ElseIf CmbIndex = Swr_K_Index Then
        HalfAdjust = 0.005 * Unit_k
        d = (dt + HalfAdjust) * Multiple_k
        s = Format(d, "##0")
    ElseIf CmbIndex = Swr___Index Then
        s = CStr(dt)
    ElseIf CmbIndex = Swr_m_Index Then
        HalfAdjust = 0.005 * Unit_m
        d = (dt + HalfAdjust) * Multiple_m
        s = Format(d, "##0")
    ElseIf CmbIndex = Swr_u_Index Then
        HalfAdjust = 0.005 * Unit_u
        d = (dt + HalfAdjust) * Multiple_u
        s = Format(d, "##0")
    ElseIf CmbIndex = Swr_n_Index Then
        HalfAdjust = 0.005 * Unit_n
        d = (dt + HalfAdjust) * Multiple_n
        s = Format(d, "##0")
    ElseIf CmbIndex = Swr_p_Index Then
        HalfAdjust = 0.005 * Unit_p
        d = (dt + HalfAdjust) * Multiple_p
        s = Format(d, "##0")
    End If

    chg_scale_unit = s
End Function
